#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from CliPlugin.ArfaRoutingSimModel import VrfTriePair
from CliPlugin.BridgingEtbaCli import showArfaAcrJson
from CliPlugin.BridgingEtbaCli import tfaNodeUnguarded
from CliPlugin.ArfaRoutingSimCli import vrfExprFactory
import ShowCommand
import CliToken.Platform

platformMatcherForShow = CliToken.Platform.platformMatcherForShow

def showArfaTrie( mode, args ):
   cmd = "TRIE_ROUTECACHE"

   vrf = args.get( 'VRF' )
   if vrf:
      cmd += " " + vrf

   return showArfaAcrJson( mode, args, VrfTriePair, cmd )

class ShowArfaRouteCacheRoutesCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform tfa routes routecache [ VRF ]'
   data = {
      'platform': platformMatcherForShow,
      'tfa': tfaNodeUnguarded,
      'routes': 'Routes programmed in Arfa',
      'routecache': 'Route cache routes programmed in Arfa',
      'VRF': vrfExprFactory
   }

   hidden = True
   handler = showArfaTrie
   cliModel = VrfTriePair

BasicCli.addShowCommandClass( ShowArfaRouteCacheRoutesCmd )
