#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from ArnetModel import IpGenericPrefix
from CliModel import Dict, Model

class TriePair( Model ):
   ipv4 = Dict( keyType=IpGenericPrefix, valueType=bool,
                help="Ipv4 routes" )
   ipv6 = Dict( keyType=IpGenericPrefix, valueType=bool,
                help="Ipv6 routes" )

   def render( self ):
      print( "IPv4 Routes" )
      for pfx in sorted( self.ipv4 ):
         print( pfx )
      print()
      print( "IPv6 Routes" )
      for pfx in sorted( self.ipv6 ):
         print( pfx )

class VrfTriePair( Model ):
   __public__ = False
   vrfs = Dict( keyType=str, valueType=TriePair,
                help="A mapping of vrfName to routes for each address family" )

   def render( self ):
      for vrf, pair in sorted( self.vrfs.items() ):
         print( "VRF:", vrf )
         pair.render()
         print()
