# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliMatcher

from CliPlugin.ReloadCli import reloadKwNode
from CliPlugin.AsuReloadCli import ( setHoldHitlessShutdown,
                                     setSkipReloadPolicyBlock )
from CliPlugin.AsuReloadEnableMode import fastbootGuardedKwNode

# --------------------------------------------------------------------------------
# Cmd Handlers
# --------------------------------------------------------------------------------
def doFastReloadHold( mode, args ):
   setHoldHitlessShutdown( set( args.values() ).isdisjoint( { 'no', 'default' } ) )

def doFastBootPolicyCheckSkip( mode, args ):
   skipChecks = set( args.values() ).isdisjoint( { 'no', 'default' } )
   setSkipReloadPolicyBlock( skipChecks )

# --------------------------------------------------------------------------------
# Common keyword matchers
# --------------------------------------------------------------------------------
debugKwMatcherforShowCmd = CliMatcher.KeywordMatcher( "debug",
                                                       helpdesc="For debugging "
                                                         "shutdown and boot path" )

#--------------------------------------------------------------------------------
# [ no | default ] reload fast-boot debug hold
#--------------------------------------------------------------------------------
class DoFastRebootHoldCmd( CliCommand.CliCommandClass ):
   syntax = 'reload fast-boot debug hold'
   data = {
      'reload': reloadKwNode,
      'fast-boot': fastbootGuardedKwNode,
      'debug': debugKwMatcherforShowCmd,
      'hold': "Hold the reload for debugging"
   }
   syncAcct = True
   noOrDefaultSyntax = syntax
   hidden = True
   handler = doFastReloadHold
   noOrDefaultHandler = doFastReloadHold

BasicCli.GlobalConfigMode.addCommandClass( DoFastRebootHoldCmd )

# --------------------------------------------------------------------------------
# [ no | default ] reload fast-boot debug policy-check skip
# --------------------------------------------------------------------------------
class DoFastBootPolicyCheckSkipCmd( CliCommand.CliCommandClass ):
   syntax = 'reload fast-boot debug policy-check skip'
   data = {
      'reload': reloadKwNode,
      'fast-boot': fastbootGuardedKwNode,
      'debug': debugKwMatcherforShowCmd,
      'policy-check': "Set the value for policy-check",
      'skip': "Skip policy checks"
   }
   noOrDefaultSyntax = syntax
   hidden = True
   handler = doFastBootPolicyCheckSkip
   noOrDefaultHandler = doFastBootPolicyCheckSkip

BasicCli.GlobalConfigMode.addCommandClass( DoFastBootPolicyCheckSkipCmd )
