#!/usr/bin/env python3
# Copyright (c) 2008-2010 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import BasicCliUtil
import CliCommand
import CliMatcher
import ConfigMount
import ShowCommand
from CliPlugin import SysMgrModels

#------------------------------------------------------------------------------------
# The "banner" commands, in config mode.
#
#  banner login LINE
#  banner motd LINE
#------------------------------------------------------------------------------------
bannerConfig = None

def setLoginBanner( mode, args ):
   banner = BasicCliUtil.getMultiLineInput( mode, cmd="banner login" )
   bannerConfig.loginBanner = banner

def clearLoginBanner( mode, args ):
   bannerConfig.loginBanner = ""

def setMotd( mode, args ):
   motd = BasicCliUtil.getMultiLineInput( mode, cmd="banner motd" )
   bannerConfig.motd = motd

def clearMotd( mode, args ):
   bannerConfig.motd = ""

class BannerLogin( CliCommand.CliCommandClass ):
   syntax = '''banner login'''
   noOrDefaultSyntax = '''banner login'''
   data = { 'banner': 'Configure system banners',
            'login': 'Set the login banner' }
   handler = setLoginBanner
   noOrDefaultHandler = clearLoginBanner 

class BannerMotd( CliCommand.CliCommandClass ):
   syntax = '''banner motd'''
   noOrDefaultSyntax = '''banner motd'''
   data = { 'banner': 'Configure system banners',
            'motd': 'Set the Message of the Day banner' }
   handler = setMotd
   noOrDefaultHandler = clearMotd

BasicCli.GlobalConfigMode.addCommandClass( BannerLogin )
BasicCli.GlobalConfigMode.addCommandClass( BannerMotd )

#------------------------------------------------------------------------------------
# The "show banner" commands
#
#  show banner login
#  show banner motd
#------------------------------------------------------------------------------------

bannerKwMatcher = CliMatcher.KeywordMatcher( 'banner',
                                             helpdesc='Show system banners' )

#-----------------------------------------------------------------------------------
# show banner login
#-----------------------------------------------------------------------------------
class ShowBannerLogin( ShowCommand.ShowCliCommandClass ):
   syntax = 'show banner login'
   data = {
            'banner': bannerKwMatcher,
            'login': 'Show the login banner',
          }
   cliModel = SysMgrModels.LoginBanner
   privileged = True

   @staticmethod
   def handler( mode, args ):
      return SysMgrModels.LoginBanner( loginBanner=bannerConfig.loginBanner )

BasicCli.addShowCommandClass( ShowBannerLogin )

#-----------------------------------------------------------------------------------
# show banner motd
#-----------------------------------------------------------------------------------
class ShowBannerMotd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show banner motd'
   data = {
            'banner': bannerKwMatcher,
            'motd': 'Show the Message of the Day banner',
          }
   cliModel = SysMgrModels.Motd
   privileged = True

   @staticmethod
   def handler( mode, args ):
      return SysMgrModels.Motd( motd=bannerConfig.motd )

BasicCli.addShowCommandClass( ShowBannerMotd )

def Plugin( entityManager ):
   global bannerConfig
   bannerConfig = ConfigMount.mount( entityManager, "sys/banner/config/cli",
                                     "System::BannerConfig", "w" )

