#!/usr/bin/env python3
# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
# pylint: disable=wrong-import-position
# pylint: disable=import-error
from __future__ import print_function, absolute_import
import sys
# from pybess import bess
# hide the import from pkgdep so that it wont complain. Use importlib
# make dsure the pkg that provides pybess is installed
# pkgdeps: rpmwith %{_datadir}/bess
import importlib

# import bess module from pybess package using import_module
sys.path.append( '/usr/share/bess' )
bess = importlib.import_module( 'pybess.bess' )

class Bessctl:
   def __init__( self ):
      self.client = bess.BESS()
      self.client.connect()

   def getBestPaths( self, vni, avt, remote ):
      args = {}
      args[ 'vni' ] = vni
      args[ 'avt_id' ] = avt
      args[ 'remote' ] = remote
      mod = [ m.name for m in
              self.client.list_modules().modules if m.mclass == 'Avt' ]
      return self.client.run_module_command( mod[ 0 ],
                                      "showBestPathForRule",
                                      "AvtRuleArg",
                                      args )
