#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable-next=consider-using-from-import
import CliPlugin.TechSupportCli as TechSupportCli
import LazyMount

bgpConfig = None

def _showBgpFlowspecGuard():
   return bgpConfig.asNumber != 0

# Register the summary commands both for the regular show-tech and the
# show-tech summary.
TechSupportCli.registerShowTechSupportCmd(
   '2020-05-12 11:05:42',
   cmds=[ 'show bgp flow-spec ipv4 summary vrf all',
          'show bgp flow-spec ipv6 summary vrf all' ],
   cmdsGuard=_showBgpFlowspecGuard,
   summaryCmds=[ 'show bgp flow-spec ipv4 summary vrf all',
                 'show bgp flow-spec ipv6 summary vrf all' ],
   summaryCmdsGuard=_showBgpFlowspecGuard,
)

TechSupportCli.registerShowTechSupportCmd(
   '2020-08-12 11:14:00',
   cmds=[ 'show bgp flow-spec ipv4 summary vrf all',
          'show bgp flow-spec ipv6 summary vrf all',
          'show bgp flow-spec ipv4 detail vrf all',
          'show bgp flow-spec ipv6 detail vrf all' ],
   cmdsGuard=_showBgpFlowspecGuard,
   extended='flow-spec' )

def Plugin( entityManager ):
   global bgpConfig

   bgpConfig = LazyMount.mount(
       entityManager, 'routing/bgp/config', 'Routing::Bgp::Config', 'r' )
