#!/usr/bin/env python3
# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=useless-object-inheritance

from __future__ import absolute_import, division, print_function

# This file contains Gated specific constants to remove the dependency between
# BgpNeighborsCliModels.py and Gated. This allows for BgpNeighborsCliModels.py to be
# moved from the Bgp package to BgpCommon.

class BgpoFlag( object ):
   BGPO_KEEPALL = 0x0400
   BGPO_KEEPNONE = 0x0800
   BGPO_REMOVE_PRIVATE = 0x04000
   BGPO_CONFED = 0x04000000
   BGPO_TTLSEC_MAXHOP = 0x1000000
   BGPO_NOCAPS = 0x20000000
   BGPO_PASSIVE = 0x80

class Bgpo2Flag( object ):
   BGPO2_EBGP_MULTIHOP = 0x200000
   BGPO2_BFD_ENABLE = 0x100000
   BGPO2_REPLACE_AS = 0x20000
   BGPO2_REMOVE_PRIVATE_AL = 0x10000

class DabitBgpPeerTcpInfo( object ):
   DABIT_BGP_PEER_TCPINFO_OPT_TIMESTAMPS = 0x5
   DABIT_BGP_PEER_TCPINFO_OPT_SACK = 0x6
   DABIT_BGP_PEER_TCPINFO_OPT_WSCALE = 0x7
   DABIT_BGP_PEER_TCPINFO_OPT_ECN = 0x8

class MioDgetTcpInfo( object ):
   MIO_DGET_BGP_PEER_TCPINFO = 0x2

class BfdStateFlag( object ):
   BFD_ADMIN_DOWN = 0x0
   BFD_INIT = 0x1
   BFD_DOWN = 0x2
   BFD_UP = 0x3

class BgpcFlag( object ):
   BGPC_V4_UNI_RESTART = 0x80000
   BGPC_V6_UNI_RESTART = 0x200000
   BGPC_MP_V6_UNI = 0x20
   BGPC_MP_V4_UNI = 0x4
   BGPC_MP_V4_LABELS = 0x100
   BGPC_MP_V6_LABELS = 0x200
   BGPC_MP_V4_SR_TE = 0x8
   BGPC_MP_V6_SR_TE = 0x10
   BGPC_MP_V4_VPNIPV4 = 0x400
   BGPC_V4_VPN_RESTART = 0x1000000
   BGPC_EXT_NEXTHOP = 0x800
   BGPC_EXT_NEXTHOP_ORIGINATE = 0x80000000
   BGPC_AS4 = 0x4000000
   BGPC_RT_REFRESH = 0x40000
   BGPC_RESTART_ANY = 0x1f800c0
   BGPC_DYN_CAPS = 0x2000000
   BGPC_V4_UNI_AP_RECV = 0x8000000
   BGPC_V4_UNI_AP_SEND = 0x10000000
   BGPC_V6_UNI_AP_RECV = 0x20000000
   BGPC_V6_UNI_AP_SEND = 0x40000000
   BGPC_V4_LABELED_UNI_AP_RECV = 0x1000
   BGPC_V4_LABELED_UNI_AP_SEND = 0x2000
   BGPC_V6_LABELED_UNI_AP_RECV = 0x4000
   BGPC_V6_LABELED_UNI_AP_SEND = 0x8000
   BGPC_NO_CAPS = 0x1

class BgpcApFlags( object ):
   BGPC_AP_RECV_ANY = 0x28005000
   BGPC_AP_SEND_ANY = 0x5000a000

class DabitBnpEntryMF( object ):
   DABIT_BNP_ENTRY_MF_MD5 = 0x10
   DABIT_BNP_ENTRY_MF_CONNECT_TIMER_STATE = 0x20
   DABIT_BNP_ENTRY_MF_IDLEHOLD_TIMER_STATE = 0x800
   DABIT_BNP_ENTRY_MF_RR_CLIENT = 0x4000
   DABIT_BNP_ENTRY_MF_NO_CLIENT_REFLECT = 0x10000
   DABIT_BNP_ENTRY_MF_RR_MESHED = 0x8000
   DABIT_BNP_ENTRY_MF_RESTART_TIMER_STATE = 0x2
   DABIT_BNP_ENTRY_MF_EOR_TIMER_STATE = 0x4
   DABIT_BNP_ENTRY_MF_IN_DEFAULT_DENY_POLICY = 0x1000
   DABIT_BNP_ENTRY_MF_OUT_DEFAULT_DENY_POLICY = 0x2000
   DABIT_BNP_ENTRY_MF_LOCAL_RESTART_STATE = 0x40
   DABIT_BNP_ENTRY_MF_LOCAL_GR_NOTIFICATION = 0x40000
   DABIT_BNP_ENTRY_MF_LOCAL_GR_V4_FWD_PRESERVE = 0x80
   DABIT_BNP_ENTRY_MF_LOCAL_GR_V6_FWD_PRESERVE = 0x100
   DABIT_BNP_ENTRY_MF_RESTART_STATE = 0x1
   DABIT_BNP_ENTRY_MF_GR_NOTIFICATION = 0x20000
   DABIT_BNP_ENTRY_MF_REMOTE_GR_V4_FWD_PRESERVE = 0x200
   DABIT_BNP_ENTRY_MF_REMOTE_GR_V6_FWD_PRESERVE = 0x400

class BgpPeerFlag( object ):
   BGPPF_V4_UNI = 0xb
   BGPPF_V4_LABELS = 0x13
   BGPPF_V4_SR_TE = 0x43
   BGPPF_V6_UNI = 0xf
   BGPPF_V6_LABELS = 0x14
   BGPPF_V6_SR_TE = 0x44
   BGPPF_V4_VPNIPV4 = 0x1c
   BGPPF_V4_VPN_RESTART = 0xa
   BGPPF_EXT_NEXTHOP = 0x3f
   BGPPF_AS4 = 0x2d
   BGPPF_RT_REFRESH = 0x15
   BGPPF_RESTART = 0x1a
   BGPPF_DYN_CAPS = 0x5
   BGPPF_AP_RECV_IPV4_UNI = 0x34
   BGPPF_AP_SEND_IPV4_UNI = 0x36
   BGPPF_AP_RECV_IPV6_UNI = 0x35
   BGPPF_AP_SEND_IPV6_UNI = 0x37
   BGPPF_AP_RECV_IPV4_LABELED_UNI = 0x3a
   BGPPF_AP_SEND_IPV4_LABELED_UNI = 0x3b
   BGPPF_AP_RECV_IPV6_LABELED_UNI = 0x3c
   BGPPF_AP_SEND_IPV6_LABELED_UNI = 0x3d
