# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# -----------------------------------------------------------------------
# Register ArBgp and BgpCliHelper show commands into "show tech-support".
# -----------------------------------------------------------------------
# pylint: disable-next=consider-using-from-import
import CliPlugin.TechSupportCli as TechSupportCli
from CliPlugin.MplsCli import mplsSupported
from Toggles.RoutingLibToggleLib import toggleBgpLsProducerBgpEpeEnabled

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmd(
   '2019-05-31 08:26:02',
   cmds=[ 'show agent Bgp task scheduler',
          'show agent BgpCliHelper task scheduler detail' ] )

TechSupportCli.registerShowTechSupportCmd(
   '2022-03-01 17:25:45',
   cmds=[ 'show mpls bgp labeled-unicast bindings detail' ],
   cmdsGuard=mplsSupported )

TechSupportCli.registerShowTechSupportCmd(
   '2022-07-18 13:03:30',
   cmds=[ 'show agent Bgp memory allocation sort current limit 50' ] )

if toggleBgpLsProducerBgpEpeEnabled():
   TechSupportCli.registerShowTechSupportCmd(
      '2024-03-25 15:39:21',
      cmds=[ 'show mpls bgp link-state bindings detail' ],
      cmdsGuard=mplsSupported )
