# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Bool, Enum, Model

class BmcStatusModel( Model ):
   personalityOnReboot = Enum( help='The personality on reboot',
                               values=( 'cpu', 'bmc' ),
                               optional=True )
   bmcInReset = Bool( help='BMC is in reset' )
   bmcUsb0PingResult = Enum( help='BMC USB0 IPv6 ping test result',
                             values=( 'bmcHubInterfaceUndetected',
                                      'bmcInterfaceUndetected',
                                      'pingUnsuccessful',
                                      'pingSuccessful' ),
                             optional=True )

   def render( self ):
      pingResultCapiToCli = \
         { 'bmcHubInterfaceUndetected': 'Failed (Undetected BMC USB Hub Interface)',
           'bmcInterfaceUndetected': 'Failed (Undetected BMC USB Interface)',
           'pingUnsuccessful': 'Failed',
           'pingSuccessful': 'Passed' }
      statusTemplate = ( 'Personality on reboot: {personalityOnReboot}\n'
                         'BMC reset status: {resetStatus}\n'
                         'BMC USB0 IPv6 ping test: {pingResult}' )
      output = statusTemplate.format(
         personalityOnReboot=self.personalityOnReboot.upper(),
         resetStatus='In Reset' if self.bmcInReset else 'Out of Reset',
         pingResult=pingResultCapiToCli[ self.bmcUsb0PingResult ] )
      print( output )
