# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AgentDirectory
import CliPlugin.TechSupportCli as TechSupportCli

sysname = None

#------------------------------------------------------------------------------
# BMC commands in "show tech-support"
#------------------------------------------------------------------------------
TechSupportCli.registerShowTechSupportCmd(
   '2018-12-04 11:26:55',
   cmds=[ 'show system bmc status' ],
   cmdsGuard=lambda: AgentDirectory.agentIsRunning( sysname, 'Bmc' ) )

#------------------------------------------------------------------------------
# Plugin
#------------------------------------------------------------------------------

def Plugin( entityManager ):
   global sysname
   sysname = entityManager.sysname()
