#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
from CliToken.Clear import clearKwNode
from CommonGuards import standbyGuard

#--------------------------------------------------------------------------------
# clear bgp monitoring internal
#--------------------------------------------------------------------------------
class ClearBgpMonitoringInternalCmd( CliCommand.CliCommandClass ):
   syntax = 'clear bgp monitoring internal'
   data = {
      'clear': clearKwNode,
      'bgp': CliMatcher.KeywordMatcher( 'bgp', helpdesc='Bgp' ),
      'monitoring': CliMatcher.KeywordMatcher( 'monitoring', 'BGP monitoring' ),
      'internal': CliCommand.Node(
         matcher=CliMatcher.KeywordMatcher(
            'internal', helpdesc='BMP Agent internal status' ),
         guard=standbyGuard ),
   }
   handler = "BmpEnableModeHandler.handlerClearBgpMonitoringInternalCmd"

BasicCliModes.EnableMode.addCommandClass( ClearBgpMonitoringInternalCmd )
