# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=unused-import
import BasicCli
import CliCommand
import ConfigMount

from CliMode.CcfAgent import CcfMode
from Tracing import Handle, t0

__defaultTraceHandle__ = Handle( 'CcfAgent' )

ccfConfig = None

class CcfConfigMode( CcfMode, BasicCli.ConfigModeBase ):
   name = 'CCF configuration'

   def __init__( self, parent, session ):
      CcfMode.__init__( self, True )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class CcfActiveCmd( CliCommand.CliCommandClass ):
   syntax = 'active'
   noOrDefaultSyntax = 'active'
   data = {
       'active': 'Enable CCF agent'
   }

   @staticmethod
   def handler( mode, args ):
      ccfConfig.active = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      ccfConfig.active = False

CcfConfigMode.addCommandClass( CcfActiveCmd )

class CcfConfigModeCmd( CliCommand.CliCommandClass ):
   syntax = 'ccf'
   noOrDefaultSyntax = syntax
   data = {
       'ccf': 'Configure Converged Cloud Fabric agent'
   }
   hidden = True

   @staticmethod
   def handler( mode, args ):
      childMode = mode.childMode( CcfConfigMode )
      mode.session_.gotoChildMode( childMode )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      ccfConfig.active = False

BasicCli.GlobalConfigMode.addCommandClass( CcfConfigModeCmd )

def Plugin( entityManager ):
   global ccfConfig
   ccfConfig = ConfigMount.mount( entityManager, 'ccf/config', 'Ccf::Config', 'w' )
