# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliToken
import LazyMount
import Tac

from CliPlugin.CdpShowCommands import matcherCdp

cdpConfig = None

#------------------------------------------------------------------------------------
# clear cdp all
#------------------------------------------------------------------------------------
def clearCounters( mode, args ):
   cdpConfig.clearStatsRequestTime = Tac.now()

tokenClearNode = CliToken.Clear.clearKwNode

class CdpClearCmd( CliCommand.CliCommandClass ):
   syntax = 'clear cdp all'
   data = {
      'clear': tokenClearNode,
      'cdp' : matcherCdp,
      'all': 'Clear CDP traffic counters and neighbors'
   }
   handler = clearCounters

BasicCliModes.EnableMode.addCommandClass( CdpClearCmd )

#-------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
#-------------------------------------------------------------------------------
def Plugin( entityManager ):
   global cdpConfig

   cdpConfig = LazyMount.mount( entityManager, "l2discovery/cdp/config",
                                "Cdp::CdpConfig", "w" )
