#!/usr/bin/env python3
# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliGlobal
import CliGuards
import LazyMount
import CliCommand

gv = CliGlobal.CliGlobal( hwCapabilities=None )

def clbGuard( mode, token ):
   return None if gv.hwCapabilities.clbSupported else CliGuards.guardNotThisPlatform

clbShowMatcher = CliCommand.guardedKeyword( 'cluster',
                                            'show Cluster Load Balancing',
                                            clbGuard )

def Plugin( entityManager ):
   gv.hwCapabilities = LazyMount.mount( entityManager,
                                        "clb/hardware/capabilities",
                                        "Clb::Hardware::Capabilities", "r" )
