# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import ( Enum, 
                       List,
                       Model )

compressedDeferredString = "Coredump with deferred compression enabled." 
compressedString = ( "Coredump with run-time compression enabled."
                     "\nThis causes delay in process restart time." )
disabledString = "Coredumping disabled." 

modeToStrMap = {
  'compressedDeferred': compressedDeferredString,
  'compressed': compressedString,
  'disabled': disabledString 
}

class SystemCoreDump( Model ):
   mode = Enum( values=list( modeToStrMap ),
                help='Core dump control mode' )
   coreFiles = List( valueType=str, help="List of core files on the device" )

   def render( self ):
      print( modeToStrMap[ self.mode ] )
      if self.mode != 'disabled':
         print( "core-files in /var/core:" )
         for coreName in self.coreFiles:
            print( coreName )
