# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import Cell
import CliCommand
import CliGlobal
import CliParser
import CliPlugin
import CliToken
import LazyMount
import ShowCommand

gv = CliGlobal.CliGlobal( memStatus=None )

def showSystemMemorySupportedGuard( mode, token ):
   # When the CpuComplex agent runs on supported platforms, it will populate Sysdb
   # with at least one memory controller.
   if len( gv.memStatus.memoryController ) > 0:
      return None
   else:
      return CliParser.guardNotThisPlatform

memoryKeyword = CliCommand.guardedKeyword( "memory", helpdesc="Show DRAM status",
                                           guard=showSystemMemorySupportedGuard )

#------------------------------------------------------------------------------------
# show system memory errors
#------------------------------------------------------------------------------------
class ShowSystemMemoryErrors( ShowCommand.ShowCliCommandClass ):
   syntax = "show system memory errors"
   data = {
         "system": CliToken.System.systemMatcherForShow,
         "memory": memoryKeyword,
         "errors": "Show DRAM ECC error counts",
   }
   cliModel = "CpuComplexCliModel.ShowSystemMemoryErrorsModel"
   handler = "CpuComplexCliHandler.showSystemMemoryErrorsHandler"

BasicCli.addShowCommandClass( ShowSystemMemoryErrors )

#------------------------------------------------------------------------------------
# "show tech-support" registration
#------------------------------------------------------------------------------------
def showTechGuard():
   return len( gv.memStatus.memoryController ) > 0

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   "2023-08-16 12:59:43",
   cmds=[ "show system memory errors" ],
   cmdsGuard=showTechGuard )

#------------------------------------------------------------------------------------
# Plugin method
#------------------------------------------------------------------------------------
def Plugin( entityManager ):
   gv.memStatus = LazyMount.mount( entityManager,
                                   f"cell/{Cell.cellId()}/hardware/memory",
                                   "Hardware::Memory", "r" )
