# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
from CliMode.DaemonCli import DaemonCliMode
from CliPlugin.LauncherDaemonCli import DaemonConfigMode

# --------------------------------------------------------------------------------
# daemon <name>; cli
# --------------------------------------------------------------------------------


class DaemonCliCmd( CliCommand.CliCommandClass ):
   syntax = 'cli'
   data = {
      'cli': 'Special debug mode, see "help" command inside the mode',
   }
   handler = "DaemonCliHandler.doDaemonCliCmd_handler"

DaemonConfigMode.addCommandClass( DaemonCliCmd )

# --------------------------------------------------------------------------------
#  daemon <name>; cli; help
# --------------------------------------------------------------------------------


class DaemonCliHelpCmd( CliCommand.CliCommandClass ):
   syntax = 'help'
   data = {
      'help': "useful info and tips",
   }
   handler = "DaemonCliHandler.doDaemonCliHelp_handler"

DaemonCliMode.addCommandClass( DaemonCliHelpCmd )
