#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
# pylint: disable-next=consider-using-from-import
import CliPlugin.DebugMessageCli as DebugMessageCli

#--------------------------------------------------------------------------------
# All non-dynamically generated commands in 'enable' mode
#--------------------------------------------------------------------------------

#--------------------------------------------------------------------------------
# ( undebug | ( no debug ) ) all
#--------------------------------------------------------------------------------
class AllCmd( CliCommand.CliCommandClass ):
   syntax = '( undebug | ( no debug ) ) all'
   data = {
      'undebug' : DebugMessageCli.matcherUndebug,
      'debug' : DebugMessageCli.matcherDebug,
      'no' : DebugMessageCli.matcherNo,
      'all' : 'All debug messages',
   }
   handler = DebugMessageCli.disableAllCategories

BasicCliModes.EnableMode.addCommandClass( AllCmd )
