# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import Model, Bool

####################################################################
# show management dmf policy state
####################################################################
class DmfPolicyModel( Model ):
   __public__ = False

   enabled = Bool( help="DMF is enabled" )
   active = Bool( help="Policy agent is active" )

   def render( self ):
      ret = "DMF: "
      if self.enabled:
         ret += "enabled"
      else:
         ret += "disabled"
      ret += "\n"
      ret += "Policy agent: "
      if self.active:
         ret += "active"
      else:
         ret += "inactive"
      print( ret )
