# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import ShowCommand
from CliPlugin import ConfigMgmtMode
from CliPlugin import DmfCli
from CliPlugin.DmfPolicyCliModel import DmfPolicyModel
from CliPlugin.DmfShowCli import registerDmfShowTech
import LazyMount

config = None
policyStatus = None

def showDmfPolicy( mode, args ):
   model = DmfPolicyModel()
   model.enabled = config.enabled
   model.active = policyStatus.active
   return model

###################################################################
# show management dmf policy
##################################################################
class DmfPolicyShowCmd( ShowCommand.ShowCliCommandClass ):
   syntax = "show management dmf policy"
   data = {
         "management": ConfigMgmtMode.managementShowKwMatcher,
         "dmf": DmfCli.dmfMatcher,
         "policy": "DMF Policy Agent",
   }

   handler = showDmfPolicy
   cliModel = DmfPolicyModel

BasicCli.addShowCommandClass( DmfPolicyShowCmd )

def Plugin( entityManager ):
   global config
   global policyStatus

   config = LazyMount.mount( entityManager,
                             "dmf/cli/config",
                             "Dmf::Cli::Config", "r" )
   policyStatus = LazyMount.mount( entityManager,
                                   "dmf/policy/status",
                                   "Dmf::Policy::Status", "r" )

   registerDmfShowTech( '2021-01-18 16:00:02',
                        [ 'show management dmf policy' ] )
