# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import LazyMount
import CliMatcher
from CliPlugin.RouteMapCli import rtMapCommListPreListRe
dynPfxListConfigDir = None

disallowRegex = "[vV][rR][fF]"
# pylint: disable-next=consider-using-f-string
dynPfxListNamePattern = ( '^(?!%s$)%s' % ( disallowRegex, rtMapCommListPreListRe ) )

dynPfxListNameMatcher = CliMatcher.DynamicNameMatcher(
    lambda mode: dynPfxListConfigDir.dynamicPrefixList,
    helpdesc='Name of dynamic prefix-list',
    pattern=dynPfxListNamePattern )

sessionBgpNameMatcher = CliMatcher.DynamicNameMatcher(
   lambda mode: dynPfxListConfigDir.sessionBgpDplList,
   helpdesc='Name of session BGP dynamic prefix-list',
   pattern=dynPfxListNamePattern )

def getDplConfigParams( dplName ):
   dplConfig = dynPfxListConfigDir.dynamicPrefixList.get( dplName, None )
   if dplConfig:
      return ( dplConfig.matchMap, dplConfig.matchRcf,
               dplConfig.ipv4PrefixList, dplConfig.ipv6PrefixList )
   else:
      return ( None, None, None, None )

def Plugin( entityManager ):
   global dynPfxListConfigDir
   dynPfxListConfigDir = LazyMount.mount(
      entityManager, 'routing/dynPfxList/config',
      'Routing::DynamicPrefixList::Config', 'r' )
