#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes, CliCommand, CliMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.BridgingCli as BridgingCli
# pylint: disable-next=consider-using-from-import
import CliPlugin.SubIntfCli as SubIntfCli
import CliPlugin.VlanCli as VlanCli # pylint: disable=consider-using-from-import
from CliPlugin.EbraEthIntfCli import switchPortMatcher
from CliPlugin.MacAddr import macAddrMatcher
from CliToken.Clear import clearKwNode

matcherAddress = CliMatcher.KeywordMatcher( 'address', 
                                            helpdesc='MAC address filter' )

#--------------------------------------------------------------------------------
# clear ( ( mac address-table ) | mac-address-table ) dynamic
#       [ ( [ vlan VLANID ] [ interface ( ETHINTF | ETHSUBINTF ) ] ) |
#         ( vlan VLANID address MACADDR ) ]
#--------------------------------------------------------------------------------
class ClearMacAddressTableDynamicCmd( CliCommand.CliCommandClass ):
   syntax = ''' clear MAC_ADDR_TABLE dynamic
                [ ( [ vlan VLANID ] [ interface ( ETHINTF | ETHSUBINTF ) ] ) |
                  ( vlan VLANID address MACADDR ) ] '''
   data = {
      'clear': clearKwNode,
      'MAC_ADDR_TABLE': BridgingCli.MacAddrTableExprForClear,
      'dynamic': 'Dynamic entries',
      'vlan': 'Per VLAN',
      'VLANID': VlanCli.vlanIdMatcher,
      'interface': BridgingCli.matcherInterface,
      'ETHINTF': switchPortMatcher,
      'ETHSUBINTF': SubIntfCli.subMatcher,
      'address': matcherAddress,
      'MACADDR': macAddrMatcher,
   }
   handler = "BridgingCliHandler.doMacAddressTableClear"

BasicCliModes.EnableMode.addCommandClass( ClearMacAddressTableDynamicCmd )
