# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.TechSupportCli # pylint: disable-msg=F0401
from CliPlugin.VlanCli import vlanMappingSupportedGuard

# Timestamps are made up to maintain historical order within show tech-support
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:04:15',
   cmds=[ 'show interfaces switchport' ] )

# Timestamps are made up to maintain historical order
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:05:00',
   cmds=[ 'show vlan' ] )

# Timestamps are made up to maintain historical order within show tech-support
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2010-01-01 00:05:10',
   cmds=[ 'show mac address-table' ] )

# Also add show mac address-table to show tech-support extended evpn
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2017-11-03 12:06:07',
   cmds=[ 'show mac address-table' ],
   extended='evpn' )

# Also add show e-tree vlan to show tech-support extended evpn
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2023-04-25 14:08:10',
   cmds=[ 'show e-tree vlan' ],
   extended='evpn' )

# Timestamps are made up to maintain historical order within show tech-support
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2016-12-19 09:30:00',
   cmds=[ 'show switch forwarding-mode' ] )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2017-11-20 17:23:22',
   cmds=[ 'show interfaces switchport vlan mapping' ],
   cmdsGuard=lambda: vlanMappingSupportedGuard( mode=None, token=None ) is None )

# Add show interfaces {trunk, trunk phone}
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2019-09-20 10:00:00',
   cmds=[ 'show interfaces trunk',
          'show interfaces trunk phone' ],
   summaryCmds=[ 'show vlan brief count' ] )

CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2020-02-21 15:10:00',
   cmds=[ 'show interface encapsulation vlan' ] )

# Add show vlan internal usage reserved
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2023-09-20 15:10:00',
   cmds=[ 'show vlan internal usage reserved' ] )

# We only emit detail for inactive and errdisabled interfaces
CliPlugin.TechSupportCli.registerShowTechSupportCmd(
   '2024-05-28 10:43:17',
   cmds=[ 'show interfaces status inactive errdisabled detail' ] )
