#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import ShowCommand
# pylint: disable-next=consider-using-from-import
import CliPlugin.EbraSnmpCli as EbraSnmpCli
import CliPlugin.IntfCli as IntfCli # pylint: disable=consider-using-from-import
from CliPlugin.SnmpCli import snmpKwMatcher, mibKwMatcherForShow

#--------------------------------------------------------------------------------
# show snmp mib bridgemib portid [ INTF ]
#--------------------------------------------------------------------------------
class SnmpMibBridgemibPortidCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show snmp mib bridgemib portid [ INTF ]'
   data = {
      'snmp': snmpKwMatcher,
      'mib': mibKwMatcherForShow,
      'bridgemib': 'Show SNMP BRIDGE-MIB contents',
      'portid': 'Show BRIDGE-MIB dot1dBasePort',
      'INTF': IntfCli.Intf.rangeMatcher,
   }
   handler = EbraSnmpCli.showSnmpPortId
   cliModel = EbraSnmpCli.PortIDs

BasicCli.addShowCommandClass( SnmpMibBridgemibPortidCmd )
