# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from CliPlugin.BridgingEtbaCli import (
      platformMatcherForShow,
      tfaNodeUnguarded,
      tfaKernelNode,
      )
from CliPlugin import TechSupportCli
import ShowCommand

class ShowEosLabKernelInterfacePathCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform tfa kernel interfaces path'
   data = {
      'platform': platformMatcherForShow,
      'tfa': tfaNodeUnguarded,
      'kernel': tfaKernelNode,
      'interfaces': 'Kernel interfaces',
      'path': 'Kernel interface path',
   }
   handler = 'EosLabEtbaCli.showEosLabKernelInterfacePath'
   cliModel = 'EosLabEtbaModel.EosLabKernelInterfacePath'

BasicCli.addShowCommandClass( ShowEosLabKernelInterfacePathCmd )

class ShowEosLabKernelInterfaceOffloadCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show platform tfa kernel interfaces offload'
   data = {
      'platform': platformMatcherForShow,
      'tfa': tfaNodeUnguarded,
      'kernel': tfaKernelNode,
      'interfaces': 'Kernel interfaces',
      'offload': 'Kernel offload settings',
   }
   handler = 'EosLabEtbaCli.showEosLabKernelInterfaceOffload'
   cliModel = 'EosLabEtbaModel.EosLabKernelInterfaceOffload'

BasicCli.addShowCommandClass( ShowEosLabKernelInterfaceOffloadCmd )

# Add all of these commands to "show tech-support extended tfa"
TechSupportCli.registerShowTechSupportCmd(
      '2023-11-03 14:14:14', cmds=[
         "show platform tfa kernel interfaces path",
         "show platform tfa kernel interfaces offload",
         ],
      extended="tfa" )
