# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import re

import CliMatcher
import CliParser
from CliParserCommon import MatchResult, noMatch

class EsiMatcher( CliMatcher.Matcher ):
   # match the following format:
   #   xxxx:xxxx:xxxx:xxxx:xxxx
   # where x is a hexadecimal number.
   # Note that this is a more strict match than Esid::stringValueIs accepts. In
   # future we might choose to relax the matcher to accept more forms.
   octetRe = '[0-9a-fA-F]{4}'
   # pylint: disable-next=consider-using-f-string
   esiPattern = '^{0}:{0}:{0}:{0}:{0}$'.format( octetRe )
   regExp = re.compile( esiPattern )
   completionRegExp = re.compile( CliParser.makePartialPattern( esiPattern ) )

   def match( self, mode, context, token ):
      m = self.regExp.match( token )
      if m is None:
         return noMatch
      return MatchResult( token, token )

   def completions( self, mode, context, token ):
      m = self.completionRegExp.match( token )
      if m is None:
         return []

      return [ CliParser.Completion( 'HHHH:HHHH:HHHH:HHHH:HHHH',
                                     self.helpdesc_, False ) ]

   def __str__( self ):
      return "<esi>"

esiMatcher = EsiMatcher( helpdesc='Ethernet Segment Identifier' )
