#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

# pylint: disable=ungrouped-imports

import CliCommand
import CliMatcher
# pylint: disable-next=consider-using-from-import
import CliPlugin.EventMonCli as EventMonCli
import BasicCliModes

matcherEventMonitor = CliMatcher.KeywordMatcher( 'event-monitor', 
      helpdesc='Run event monitor actions' )

#--------------------------------------------------------------------------------
# event-monitor clear
#--------------------------------------------------------------------------------
class EventMonitorClearCmd( CliCommand.CliCommandClass ):
   syntax = 'event-monitor clear'
   data = {
      'event-monitor': matcherEventMonitor,
      'clear': 'Clear the event monitor logs',
   }
   handler = EventMonCli.clearLogs

BasicCliModes.EnableMode.addCommandClass( EventMonitorClearCmd )

#--------------------------------------------------------------------------------
# event-monitor interact
#--------------------------------------------------------------------------------
class EventMonitorInteractCmd( CliCommand.CliCommandClass ):
   syntax = 'event-monitor interact'
   data = {
      'event-monitor': matcherEventMonitor,
      'interact': 'Replace EOS Cli with SQLite Cli',
   }
   handler = EventMonCli.interactSQLite

BasicCliModes.EnableMode.addCommandClass( EventMonitorInteractCmd )

#--------------------------------------------------------------------------------
# event-monitor sync
#--------------------------------------------------------------------------------
class EventMonitorSyncCmd( CliCommand.CliCommandClass ):
   syntax = 'event-monitor sync'
   data = {
      'event-monitor': matcherEventMonitor,
      'sync': 'Sync the event monitor logs to the SQLite database',
   }
   handler = EventMonCli.syncBuffer

BasicCliModes.EnableMode.addCommandClass( EventMonitorSyncCmd )
