# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import LazyMount
import CliCommand
import CliMatcher
import CliToken.Clear
import SharkLazyMount
import SmashLazyMount
import Tac

status = None
counter = None
counterStatus = None
vrfSmash = None

countersMatcherForClear = CliMatcher.KeywordMatcher(
      'counters', helpdesc='Clear flow-spec counters in all sessions' )
flowSpecMatcherForClear = CliMatcher.KeywordMatcher(
      'flow-spec', helpdesc='Clear flow-spec' )

#--------------------------------------------------------------------------------
# clear flow-spec counters
#--------------------------------------------------------------------------------
def clearCounters( mode, args ):
   LazyMount.force( status )
   LazyMount.force( counter )
   counterStatusEntity = SharkLazyMount.force( counterStatus )

   cliHelper = Tac.newInstance( 'Flowspec::Cli::FlowspecClear', status, counter,
                                vrfSmash, counterStatusEntity )
   cliHelper.clearFlowspec()

class ClearFlowSpecCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear flow-spec counters'
   data = {
      'clear' : CliToken.Clear.clearKwNode,
      'flow-spec' : flowSpecMatcherForClear,
      'counters' : countersMatcherForClear,
   }
   handler = clearCounters

BasicCli.EnableMode.addCommandClass( ClearFlowSpecCountersCmd )

#--------------------------------------------------------------------------------
# clear flow-spec counters session
#--------------------------------------------------------------------------------
def clearCountersSession( mode, args ):
   sessionCounter = mode.session.sessionData( 'FlowspecSessionCounter', None )
   if sessionCounter is None:
      sessionCounter = Tac.newInstance( 'Flowspec::Counter', 'sessionCounter' )
      mode.session.sessionDataIs( 'FlowspecSessionCounter', sessionCounter )
   LazyMount.force( status )
   counterStatusEntity = SharkLazyMount.force( counterStatus )
   cliHelper = Tac.newInstance( 'Flowspec::Cli::FlowspecClear', status,
                                sessionCounter, vrfSmash, counterStatusEntity )
   cliHelper.clearFlowspec()

class ClearFlowSpecCountersSessionCmd( CliCommand.CliCommandClass ):
   syntax = 'clear flow-spec counters session'
   data = {
      'clear' : CliToken.Clear.clearKwNode,
      'flow-spec' : flowSpecMatcherForClear,
      'counters' : countersMatcherForClear,
      'session' : 'Clear flow-spec counters in current session',
   }
   handler = clearCountersSession

BasicCli.EnableMode.addCommandClass( ClearFlowSpecCountersSessionCmd )

#------------------------------------------------------------------------------------
# Plugin
#------------------------------------------------------------------------------------

def Plugin( entityManager ):
   global status
   global counter
   global counterStatus
   global vrfSmash

   status = LazyMount.mount( entityManager, "flowspec/status",
                             "Flowspec::Status", "r" )
   counter = LazyMount.mount( entityManager, "flowspec/counter",
                              "Flowspec::Counter", "wr" )
   sharkMountInfo = SharkLazyMount.mountInfo( 'shadow' )
   counterStatus = SharkLazyMount.mount(
      entityManager,
      "policyMap/counters/flowspec",
      "PolicyMap::Counters::PolicyMapTypeCounters",
      sharkMountInfo,
      autoUnmount=True )
   vrfSmash = SmashLazyMount.mount( entityManager, "vrf/vrfIdMapStatus",
                                    "Vrf::VrfIdMap::Status",
                                    SmashLazyMount.mountInfo( 'reader' ),
                                    autoUnmount=True )
