#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.AssetTags as AssetTags # pylint: disable=consider-using-from-import
from CliPlugin.FruCli import SwitchOrModuleExpression
from CliToken.Hardware import hardwareMatcherForExec

#--------------------------------------------------------------------------------
# [ no | default ] hardware asset-tag MODULE TAG
#--------------------------------------------------------------------------------
class HardwareAssetTagTagCmd( CliCommand.CliCommandClass ):
   syntax = 'hardware asset-tag MODULE TAG'
   noOrDefaultSyntax = 'hardware asset-tag MODULE ...'
   data = {
      'hardware' : hardwareMatcherForExec,
      'asset-tag' : 'User-specified asset tags/IDs',
      'MODULE' : SwitchOrModuleExpression,
      'TAG' : CliMatcher.PatternMatcher( pattern=r'.+',
                                         helpdesc='User-supplied asset tag/ID',
                                         helpname='WORD' ),
   }

   handler = AssetTags.doSetAssetTag
   noOrDefaultHandler = handler

BasicCliModes.EnableMode.addCommandClass( HardwareAssetTagTagCmd )
