# Copyright (c) 2021 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import Arnet
from CliModel import Model, Str, Dict
import TableOutput

class ForwardingChip( Model ):
   slotLabel = Str( help='Slot label' )
   chipLabel = Str( help='Chip label' )
   chipVer = Str( help='Chip version' )
   chipName = Str( help='Chip name' )
   forwardingAgent = Str( help='Forwarding agent' )

class ForwardingChipsModel( Model ):
   chips = Dict( keyType=str, valueType=ForwardingChip, help='Forwarding chips '
                    'on this system, keyed by slot and chip label' )

   def render( self ):
      table = TableOutput.createTable(
         ( 'Slot', 'Chip Label', 'Chip Version', 'Chip Name', 'Forwarding Agent' ) )
      strFmt = TableOutput.Format( justify='left' )
      strFmt.padLimitIs( True )
      table.formatColumns( strFmt, strFmt, strFmt, strFmt, strFmt )
      for fwdChipId in Arnet.sortIntf( self.chips ):
         fwdChip = self.chips[ fwdChipId ]
         table.newRow( fwdChip.slotLabel,
                       fwdChip.chipLabel,
                       fwdChip.chipVer,
                       fwdChip.chipName,
                       fwdChip.forwardingAgent )

      print( table.output().rstrip( '\n' ) )
