#/usr/bin/env python
# Copyright (c) 2010, 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliExtensions

pimEnableHook = []
pimLocalInterfaceHook = []

def registerPimEnableIgmpHook( hook ):
   '''Registers the given hook function to be called when PIM is enabled on an
   interface.  The function should expect two arguments: the interface Mode object,
   and a boolean: True if PIM is being enabled, False if PIM is being disabled.'''
   pimEnableHook.append( hook )

def registerPimLocalInterfaceIgmpHook( hook ):
   '''Registers the given hook function to be called when PIM uses local-interface
   ( interface from which it borrows the IP ) on an interface.  The function should
   expect two arguments: the interface Mode object and a interfaceId.  The
   interfaceId represents the interface from which it is borrowing the IP.'''
   pimLocalInterfaceHook.append( hook )

# Hook to get a set of IGMP enabled interfaces
igmpEnabledIntfsHook = CliExtensions.CliHook()

# Hook to get the IGMP status
igmpStatusCollHook = CliExtensions.CliHook()

# Hook to get vlans where Igmp Snooping Querier has been configured
igmpSnoopingQuerierEnabledVlansHook = CliExtensions.CliHook()
