# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.


import BasicCli
import CliCommand
import CliMatcher
import ConfigMount
from CliToken.Service import serviceKw
from CliPlugin.IntfCli import intfAfterServiceKwMatcher

config = None 

class AdminShutdownDelay:
   lower = 1
   upper = 1000

#-------------------------------------------------------------------------------
# The '[ no | default ] service interface shutdown delay <0-1000> command.
#-------------------------------------------------------------------------------
class ServiceInterfaceShutdownDelay( CliCommand.CliCommandClass ):
   syntax = 'service interface shutdown delay DELAY'
   noOrDefaultSyntax = 'service interface shutdown delay ...'
   data = {
      'service' : serviceKw,
      'interface' : intfAfterServiceKwMatcher,
      'shutdown' : 'Change interface shutdown parameters',
      'delay' : 'Configure delay time',
      'DELAY' : CliMatcher.IntegerMatcher( lbound=AdminShutdownDelay.lower,
                                           ubound=AdminShutdownDelay.upper,
                                           helpdesc='Delay time in milliseconds' )
   }

   @staticmethod
   def handler( mode, args ):
      if config.globalConfig is None:
         config.globalConfig = ( 'GlobalConfig', )
      delay = args['DELAY']
      config.globalConfig.delay = delay

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      config.globalConfig = None

BasicCli.GlobalConfigMode.addCommandClass( ServiceInterfaceShutdownDelay )

def Plugin( entityManager ):
   global config

   config = ConfigMount.mount( entityManager,
                               'goodbye/config',
                               'Goodbye::Config::ConfigDir',
                               'w' )
