#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
from CliPlugin.AclCli import countersKwMatcher
import CliPlugin.IgmpCli as IgmpCli # pylint: disable=consider-using-from-import
import CliPlugin.VrfCli as VrfCli # pylint: disable=consider-using-from-import
from CliPlugin.IntfCli import Intf
from CliPlugin.IpAddrMatcher import IpAddrMatcher
from CliPlugin.IgmpShowCommands import matcherAccessList, nodeIgmp
from CliToken.Ip import ipMatcherForClear
from CommonGuards import ssoStandbyGuard

nodeClear = CliCommand.guardedKeyword( 'clear',
      helpdesc='Reset functions', guard=ssoStandbyGuard )
matcherGroup = CliMatcher.KeywordMatcher( 'group',
      helpdesc='Delete IGMP group cache state' )
matcherInterface = CliMatcher.KeywordMatcher( 'interface',
      helpdesc='Clear join state on a specific interface' )
matcherStatistics = CliMatcher.KeywordMatcher( 'statistics',
      helpdesc='Clear IGMP counters' )
vrfExprFactory = VrfCli.VrfExprFactory(
      helpdesc='VRF name' )
#--------------------------------------------------------------------------------
# clear ip igmp access-list counters
#--------------------------------------------------------------------------------
class ClearIpIgmpAccessListCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear ip igmp access-list counters'
   data = {
      'clear' : nodeClear,
      'ip' : ipMatcherForClear,
      'igmp' : nodeIgmp,
      'access-list' : matcherAccessList,
      'counters' : countersKwMatcher,
   }
   handler = IgmpCli.clearIpAclCounters

BasicCliModes.EnableMode.addCommandClass( ClearIpIgmpAccessListCountersCmd )

#--------------------------------------------------------------------------------
# clear ip igmp [ vrf VRF ] group [ GROUPADDR ] [ interface INTF ]
#--------------------------------------------------------------------------------
class ClearIpIgmpGroupaddrIntfCmd( CliCommand.CliCommandClass ):
   syntax = 'clear ip igmp [ VRF ] group [ GROUPADDR ] [ interface INTF ]'
   data = {
      'clear' : nodeClear,
      'ip' : ipMatcherForClear,
      'igmp' : nodeIgmp,
      'VRF' : vrfExprFactory,
      'group' : matcherGroup,
      'GROUPADDR' : IpAddrMatcher( helpdesc='Multicast group address' ),
      'interface' : matcherInterface,
      'INTF' : Intf.matcher,
   }
   handler = IgmpCli.cmdClearIpIgmpGroup

BasicCliModes.EnableMode.addCommandClass( ClearIpIgmpGroupaddrIntfCmd )

#--------------------------------------------------------------------------------
# clear ip igmp [ vrf VRF ] statistics [ interface INTF ]
#--------------------------------------------------------------------------------
class ClearIpIgmpStatisticsCmd( CliCommand.CliCommandClass ):
   syntax = 'clear ip igmp [ VRF ] statistics [ interface INTF ]'
   data = {
      'clear' : nodeClear,
      'ip' : ipMatcherForClear,
      'igmp' : nodeIgmp,
      'VRF' : vrfExprFactory,
      'statistics' : matcherStatistics,
      'interface' : matcherInterface,
      'INTF' : Intf.matcher,
   }
   handler = IgmpCli.cmdClearIpIgmpStatistics

BasicCliModes.EnableMode.addCommandClass( ClearIpIgmpStatisticsCmd )
