#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
from CliToken.Router import routerMatcherForConfig
from CliPlugin.RouterIgmp import RouterIgmpMode
from CliPlugin.VrfCli import DEFAULT_VRF
import CliParser
import CliExtensions

deleteRouterIgmpModeHook = CliExtensions.CliHook()
# addRouterIgmpVrfModeHook hook notify all callbacks registered with it,
# when router igmp or VRF mode under router igmp is executed.
# In case of router igmp execution, it notify callbacks for default VRF.
addRouterIgmpVrfModeHook = CliExtensions.CliHook()
# deleteRouterIgmpVrfModeHook hook is used for clean up when under router igmp
# no vrf <vrfName> command is being executed
deleteRouterIgmpVrfModeHook = CliExtensions.CliHook()

_routingHardwareStatus = None
matcherIgmp = CliMatcher.KeywordMatcher( 'igmp',
      helpdesc='Configure IGMP protocol' )
def mcastRoutingSupported( sysdbRoot, routingHardwareStatus=None ):
   if routingHardwareStatus is None:
      routingHardwareStatus = sysdbRoot[ 'routing' ][ 'hardware' ][ 'status' ]
   return routingHardwareStatus.multicastRoutingSupported

def mcastRoutingSupportedGuard( mode, token ):
   if mcastRoutingSupported( mode.sysdbRoot, _routingHardwareStatus ):
      return None
   return CliParser.guardNotThisPlatform

nodeIgmp = CliCommand.Node( matcher=matcherIgmp, guard=mcastRoutingSupportedGuard )


#--------------------------------------------------------------------------------
# [ no | default ] router igmp
#--------------------------------------------------------------------------------
class RouterIgmpCmd( CliCommand.CliCommandClass ):
   syntax = 'router igmp'
   noOrDefaultSyntax = syntax
   data = {
      'router' : routerMatcherForConfig,
      'igmp' : nodeIgmp,
   }
   
   @staticmethod
   def handler( mode, args ):
      childMode = mode.childMode( RouterIgmpMode )
      mode.session_.gotoChildMode( childMode )
      addRouterIgmpVrfModeHook.notifyExtensions( DEFAULT_VRF )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      for hook in deleteRouterIgmpModeHook.extensions():
         hook( mode, args )


BasicCliModes.GlobalConfigMode.addCommandClass( RouterIgmpCmd )

