# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliPlugin import TechSupportCli
from CliPlugin.IgmpCli import ipIgmpSupportedGuard
from CliPlugin.GmpShowTechCli import registerShowTechMulticast, ShowTechMulticastType
import Toggles.GmpToggleLib

if Toggles.GmpToggleLib.toggleMulticastShowTechEnabled():
   showTechIgmpCmds = [ 'show ip igmp vrf {} interface',
                        'show ip igmp vrf {} static-groups',
                        'show ip igmp vrf {} groups detail',
                        'show ip igmp vrf {} statistics' ]
   registerShowTechMulticast( showTechIgmpCmds,
                              showTechMcastType=ShowTechMulticastType.vrf,
                              guard=ipIgmpSupportedGuard )
else:
   TechSupportCli.registerShowTechSupportCmd(
      '2010-06-11 04:00:00',
      cmds=[ 'show ip igmp interface',
             'show ip igmp static-groups',
             'show ip igmp groups detail',
             'show ip igmp membership' ],
      cmdsGuard=lambda: ipIgmpSupportedGuard( mode=None, token=None ) is None )

