#!/usr/bin/env python3
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliToken.Monitor
from CliPlugin import InfluxTelemetryModel
import LazyMount
import ShowCommand

# Globals
_status = None
_config = None

#-----------------------------------------------------------------
# show monitor telemetry influx
#-----------------------------------------------------------------
class ShowMonitorInfluxTelemetryCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show monitor telemetry influx'
   data = {
      'monitor': CliToken.Monitor.monitorMatcherForShow,
      'telemetry': 'Show monitor telemetry information',
      'influx': 'Show influx telemetry information',
   }
   cliModel = InfluxTelemetryModel.InfluxTelemetry

   @staticmethod
   def handler( mode, args ):
      telemetryInflux = InfluxTelemetryModel.InfluxTelemetry()
      telemetryInflux.telegrafRunning = _status.running

      # Cli config destination influxdb
      for name, dest in _config.destinationInfluxdbConfig.items():
         destModel = InfluxTelemetryModel.DestinationInfluxdb()
         destModel.fetchSysdbState( dest )
         telemetryInflux.destinationInfluxdb[ name ] = destModel

      # Cli config source group socket
      for group, status in _config.sourceGroups.items():
         telemetryInflux.sourceGroups[ group ] = status

      # Cli config source socket
      for name, socket in _config.sourceSocketConfig.items():
         socketModel = InfluxTelemetryModel.SourceSocket()
         socketModel.fetchSysdbState( socket )
         telemetryInflux.sourceSocket[ name ] = socketModel

      # Cli config global tags
      for tag, value in _config.globalTags.items():
         telemetryInflux.globalTags[ tag ] = value

      return telemetryInflux

BasicCli.addShowCommandClass( ShowMonitorInfluxTelemetryCmd )

def Plugin( entityManager ):
   global _status, _config

   _status = LazyMount.mount(
      entityManager,
      'telegrafMgr/status', 'TelegrafMgr::TelegrafMgrStatus', 'r' )
   _config = LazyMount.mount(
      entityManager,
      'telegrafMgr/config', 'TelegrafMgr::TelegrafMgrConfig', 'r' )
