# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
from CliMode.IntfGroup import IntfGroupMode, IntfBuiltinGroupMode
from CliPlugin.GroupLib import GroupConfigMode

class IntfGroupConfigMode( GroupConfigMode, IntfGroupMode, BasicCli.ConfigModeBase ):
   name = "Group Interface configuration"

   def __init__( self, parent, session, intfGroup ):
      GroupConfigMode.__init__( self, session, intfGroup )
      IntfGroupMode.__init__( self, intfGroup.name() )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class IntfBuiltinGroupConfigMode( GroupConfigMode, IntfBuiltinGroupMode,
                                  BasicCli.ConfigModeBase ):
   name = "Builtin Group Interface configuration"

   def __init__( self, parent, session, intfBuiltinGroup, builtinModeName ):
      GroupConfigMode.__init__( self, session, intfBuiltinGroup )
      IntfBuiltinGroupMode.__init__( self, builtinModeName )
      BasicCli.ConfigModeBase.__init__( self, parent, session )
