# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# This module implements a single command:
# - the "show interfaces single <name>" command
# This command exists only for testing, and is not installed in the image.
#-------------------------------------------------------------------------------
import BasicCli
from CliPlugin import IntfCli
from CliPlugin import IntfModel
import ShowCommand

class ShowIntfSingleCommand( ShowCommand.ShowCliCommandClass ):
   syntax = "show interfaces single INTF"
   data = {
         'interfaces' : IntfCli.interfacesShowKw,
         'single' : 'A single interface for test purposes only',
         'INTF' : IntfCli.Intf.matcher,
         }
   cliModel = IntfModel.InterfaceStatuses
   handler = IntfCli.showInterfaces
   hidden = True

BasicCli.addShowCommandClass( ShowIntfSingleCommand )
