#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import ShowCommand
# pylint: disable-next=consider-using-from-import
import CliPlugin.IntfSnmpCli as IntfSnmpCli
import CliPlugin.IntfCli as IntfCli # pylint: disable=consider-using-from-import
from CliPlugin.SnmpCli import snmpKwMatcher, mibKwMatcherForShow

#--------------------------------------------------------------------------------
# show snmp mib ifmib ifindex [ INTF ]
#--------------------------------------------------------------------------------
class SnmpMibIfmibIfindexCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show snmp mib ifmib ifindex [ INTF ]'
   data = {
      'snmp': snmpKwMatcher,
      'mib': mibKwMatcherForShow,
      'ifmib': 'Show SNMP IF-MIB contents',
      'ifindex': 'Show IF-MIB ifIndex',
      'INTF': IntfCli.Intf.rangeMatcher,
   }
   handler = IntfSnmpCli.showSnmpIfIndex
   cliModel = IntfSnmpCli.SnmpMibIfIndex

BasicCli.addShowCommandClass( SnmpMibIfmibIfindexCmd )
