# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#------------------------------------------------------------------------------
# Implements routing related Etba commands
#
# maximim-paths: Set "hardware" maximum ecmp paths. Maybe set at init.
#------------------------------------------------------------------------------

import CliMatcher, CliCommand, ShowCommand, BasicCli
#from BridgingEtbaCli import tokenEtba

# Has to copy from BridgingEtbaCli to avoid circular dep.
etbaKw = CliMatcher.KeywordMatcher( 'etba',
           helpdesc='Ebra Test Bridge configuration commands' )

maxEcmpKw = CliMatcher.KeywordMatcher(
   "maximum-paths",
   helpdesc="Maximum etba dut ECMP paths" )

def showEtbaMaximumPathsCmd():
   return "show etba maximum-paths"

class SetMaxEcmpCmd( CliCommand.CliCommandClass ):
   syntax = '''etba maximum-paths MAX'''
   noOrDefaultSyntax = '''etba maximum-paths ...'''
   data = { 'etba': etbaKw,
            'maximum-paths': maxEcmpKw,
            'MAX': CliMatcher.IntegerMatcher( 0, 128, helpdesc="Maximum paths" )
          }

   handler = "IraEtbaCliHandler.handlerSetMaxEcmpCmd"
   noOrDefaultHandler = handler

BasicCli.GlobalConfigMode.addCommandClass( SetMaxEcmpCmd )

class ShowMaxEcmpCmd( ShowCommand.ShowCliCommandClass ):
   syntax = '''show etba maximum-paths'''
   data = { 'etba': etbaKw,
            'maximum-paths': maxEcmpKw
          }

   handler = "IraEtbaCliHandler.handlerShowMaxEcmpCmd"

BasicCli.addShowCommandClass( ShowMaxEcmpCmd )
