#!/usr/bin/env python3
# Copyright (c) 2024 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from BasicCliModes import GlobalConfigMode
from CliCommand import CliCommandClass
from CliToken.Ip import ipMatcherForConfig

# -------------------------------------------------------------------------------
# [ no | default ] ip software forwarding options action drop
# -------------------------------------------------------------------------------
class IpSoftwareForwardingOptionsCmd( CliCommandClass ):
   syntax = 'ip software forwarding options action drop'
   noOrDefaultSyntax = syntax
   data = {
      'ip': ipMatcherForConfig,
      'software': 'Configure software-specific parameters',
      'forwarding': 'Software forwarding configuration',
      'options': 'Configure software forwarding for IPv4 options packet',
      'action': 'Configure action on IPv4 options packet',
      'drop': 'Drop IPv4 options packet in software',
   }

   handler = "IraIpOptionForwardingCliHandler.enableSoftwareIpOptionsDrop"
   noOrDefaultHandler = (
      "IraIpOptionForwardingCliHandler.disableSoftwareIpOptionsDrop" )

GlobalConfigMode.addCommandClass( IpSoftwareForwardingOptionsCmd )
