# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliExtensions
import CliCommand
import CliPlugin.VrfCli as VrfCli # pylint: disable=consider-using-from-import
from CliMode.Ira import RouterKernelMode
from CliToken.Router import routerMatcherForConfig as keywordRouter

routerKernelVrfHook = CliExtensions.CliHook()

#-------------------------------------------------------------------------------
# router kernel - config mode. 
#-------------------------------------------------------------------------------
class RouterKernelConfigMode( RouterKernelMode, BasicCli.ConfigModeBase ):
   name = 'Kernel Route configuration'

   #----------------------------------------------------------------------------
   # Constructs a new RouterKernelConfigMode instance.
   #----------------------------------------------------------------------------
   def __init__( self, parent, session, vrfName ):
      RouterKernelMode.__init__( self, ( vrfName ) )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

class RouterKernelConfigModeCmd( CliCommand.CliCommandClass ):
   syntax = 'router kernel [ VRF ]'
   noOrDefaultSyntax = syntax

   data = {
      'router': keywordRouter,
      'kernel': 'Routes installed by kernel',
      'VRF': VrfCli.VrfExprFactory( helpdesc='VRF name',
                                    inclDefaultVrf=True ),
   }

   handler = "IraRouterKernelHandler.handlerRouterKernelConfigModeCmd"
   noOrDefaultHandler = \
      "IraRouterKernelHandler.noOrDefaultHandlerRouterKernelConfigModeCmd"

BasicCli.GlobalConfigMode.addCommandClass( RouterKernelConfigModeCmd )
