#!/usr/bin/env python3
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import  GeneratorDict, Model

def generateIsisDictCliModel( cliModel, revision=1 ):
   instances = GeneratorDict( valueType=cliModel,
                              help='IS-IS Instance list keyed by instance name' )
   def render( self ):
      for _, model in self.isisInstances:
         model.render()
  
   # pylint: disable-next=consider-using-f-string
   className = 'Instances%s' % cliModel.__name__
   classBody = { '__revision__' : revision,
                 'isisInstances' : instances,
                 'render' : render
                 }
   
   return type( className, ( Model, ), classBody )
