# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import Cell
import CliCommand
import ConfigMount
import CliParser
from CliPlugin.ThermoMgrGlobalConfigMode import matcherEnvironment
import LazyMount

cliConfig = None
kabiniConfig = None

def cpuTdpGuard( mode, token ):
   if kabiniConfig.tdpToCpuFreq:
      return None
   return CliParser.guardNotThisPlatform

class CpuTdpCmd( CliCommand.CliCommandClass ):
   syntax = 'environment power cpu tdp lowest'
   noOrDefaultSyntax = syntax

   data = {
      'environment': matcherEnvironment,
      'power': 'Configure the system behavior for power',
      'cpu': CliCommand.guardedKeyword( 'cpu',
                                        helpdesc='CPU settings',
                                        guard=cpuTdpGuard ),
      'tdp': 'Thermal Design Power State',
      'lowest': 'Run CPUs at lowest power state',
   }
   handler = "KabiniCliHandler.cpuTdpCmdHandler"
   noOrDefaultHandler = "KabiniCliHandler.cpuTdpCmdNoOrDefaultHandler"

BasicCli.GlobalConfigMode.addCommandClass( CpuTdpCmd )

def Plugin( entityManager ):
   global cliConfig, kabiniConfig
   cliConfig = ConfigMount.mount( entityManager,
      "kabini/cliConfig",
      'Kabini::CliConfig', 'w' )
   kabiniConfig = LazyMount.mount( entityManager,
      f"hardware/cell/{Cell.cellId()}/kabini/config",
      'Hardware::Kabini::KabiniConfig', 'r' )
