# Copyright (c) 2023 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This module provides the CLI show commands used to enumerate existing L1 profiles
on a system.
'''

import BasicCli
import CliCommand
from CliGlobal import CliGlobal
import CliMatcher
from CliPlugin import (
   TechSupportCli,
   L1ProfileCliGuard,
)
from CliPlugin.L1ProfileCliCommon import L1ProfileSupportedModulesRangeMatcher
import CliToken.L1Profile
import LazyMount
import ShowCommand
from TypeFuture import TacLazyType

MountConstants = TacLazyType( 'L1Profile::MountConstants' )
ProductConfig = TacLazyType( 'L1Profile::ProductConfig' )

gv = CliGlobal( productConfig=None )

class L1CardProfileEnumerationCommand( ShowCommand.ShowCliCommandClass ):
   syntax = 'show l1 modules [ MOD ] profile configuration [ name NAME ]'
   data = { 'l1': CliToken.L1Profile.profileShowKeywordL1,
            'modules': 'Display module wide L1 parameters',
            'MOD': CliCommand.Node(
                      matcher=L1ProfileSupportedModulesRangeMatcher(),
                      guard=L1ProfileCliGuard.modularSystemGuard ),
            'profile': 'Display L1 module profile parameters',
            'configuration': 'Display available L1 module profiles',
            'name': 'Filter by L1 module profile name',
            'NAME': CliMatcher.StringMatcher(
               pattern=r'[A-Za-z0-9/_-]+',
               helpdesc='Search criteria for L1 module profile name'
                        ' (case insensitive)' )
   }

   cliModel = 'L1CardProfileEnumerationModel.Summary'
   handler = 'L1CardProfileEnumerationHandler.handler'

BasicCli.addShowCommandClass( L1CardProfileEnumerationCommand )

TechSupportCli.registerShowTechSupportCmd(
   '2023-03-14 14:28:40',
   cmds=[ 'show l1 modules profile configuration' ],
   cmdsGuard=lambda: gv.productConfig.enabled )

def Plugin( em ):
   gv.productConfig = LazyMount.mount(
      em,
      MountConstants.productConfigPath(),
      ProductConfig.tacType.fullTypeName,
      'r' )
