# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

'''This module provides the CLI show commands used to query the status of L1
profiles on a system.
'''

from CliPlugin import (
   L1ProfileCliGuard,
   TechSupportCli,
)
from CliPlugin.L1ProfileCliCommon import L1ProfileSupportedModulesRangeMatcher
import BasicCli
import CliCommand
from CliGlobal import CliGlobal
import CliToken.L1Profile
import LazyMount
import ShowCommand
from TypeFuture import TacLazyType

MountConstants = TacLazyType( 'L1Profile::MountConstants' )
ProductConfig = TacLazyType( 'L1Profile::ProductConfig' )

gv = CliGlobal( productConfig=None )

class L1CardProfileStatusCommand( ShowCommand.ShowCliCommandClass ):
   syntax = 'show l1 modules [ MOD ] profile status'
   data = { 'l1': CliToken.L1Profile.profileShowKeywordL1,
            'modules': 'Display module wide L1 parameters',
            'MOD': CliCommand.Node(
                   matcher=L1ProfileSupportedModulesRangeMatcher(),
                   guard=L1ProfileCliGuard.modularSystemGuard ),
            'profile': 'Display L1 module profile parameters',
            'status': 'Display L1 module profile configuration status',
   }

   cliModel = 'L1CardProfileStatusModel.Summary'
   handler = 'L1CardProfileStatusHandler.handler'

BasicCli.addShowCommandClass( L1CardProfileStatusCommand )

TechSupportCli.registerShowTechSupportCmd(
   '2022-11-10 11:51:39',
   cmds=[ 'show l1 modules profile status' ],
   cmdsGuard=lambda : gv.productConfig.enabled )

def Plugin( em ):
   gv.productConfig = LazyMount.mount(
      em,
      MountConstants.productConfigPath(),
      ProductConfig.tacType.fullTypeName,
      'r' )
