# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliMatcher
import CliParser
from CliToken.PortChannel import (
      portChannelMatcherForShow,
)
import LazyMount

# Globals written by the Plugin function at the end of this file
bridgingHwCapabilities = None

def dlbLagSupportedGuard( mode, token ):
   if bridgingHwCapabilities.lagDlbSupported:
      return None
   return CliParser.guardNotThisPlatform

def lagSupportedGuard( mode, token ):
   if bridgingHwCapabilities.lagSupported:
      return None
   return CliParser.guardNotThisPlatform

distributionMatcherForConfig = CliCommand.Node(
      CliMatcher.KeywordMatcher( 'distribution',
         helpdesc='Configure load balance distribution type' ),
      guard=dlbLagSupportedGuard )

distributionMatcherForShow = CliCommand.Node(
      CliMatcher.KeywordMatcher( 'distribution',
         helpdesc='Display load balance distribution type' ),
      guard=dlbLagSupportedGuard )

portChannelNodeForShow = CliCommand.Node(
      matcher=portChannelMatcherForShow,
      guard=lagSupportedGuard )

# -------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
# -------------------------------------------------------------------------------
def Plugin( entityManager ):
   global bridgingHwCapabilities

   bridgingHwCapabilities = LazyMount.mount( entityManager,
                                             "bridging/hwcapabilities",
                                             "Bridging::HwCapabilities", "r" )
