# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
from CliPlugin.LagDlbModel import (
      GlobalDlbLag,
)
from CliPlugin.LagCommonCliLib import (
      distributionMatcherForShow,
      portChannelNodeForShow,
)
from CliToken.LoadBalance import (
      loadBalancePortChannelMatcherForShow,
)
import LazyMount
import ShowCommand

dlbLagConfig = None

# -------------------------------------------------------------------------------
# show port-channel load-balance distribution
# -------------------------------------------------------------------------------
class ShowPortChannelLoadBalanceDistCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show port-channel load-balance distribution'
   data = {
      'port-channel': portChannelNodeForShow,
      'load-balance': loadBalancePortChannelMatcherForShow,
      'distribution': distributionMatcherForShow
   }

   cliModel = GlobalDlbLag

   @staticmethod
   def handler( mode, args ):
      GlobalDlbLagModel = GlobalDlbLag()
      GlobalDlbLagModel.globalDlbLagEnabled = dlbLagConfig.globalDlbLagEnable
      return GlobalDlbLagModel

BasicCli.addShowCommandClass( ShowPortChannelLoadBalanceDistCmd )

# -------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
# -------------------------------------------------------------------------------
def Plugin( entityManager ):
   global dlbLagConfig

   dlbLagConfig = LazyMount.mount( entityManager, "lag/hardware/dlb/config",
                                     "Lag::Hardware::DlbConfig", "r" )
