# Copyright (c) 2022 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from CliModel import (
      Bool,
      Model
)

# -------------------------------------------------------------------
# model for "show port-channel load-balance distribution"
# -------------------------------------------------------------------

class GlobalDlbLag( Model ):
   globalDlbLagEnabled = \
      Bool( help="Dynamic load balancing on LAG is enabled globally" )

   def render( self ):
      print( "" )
      lb = 'dynamic' if self.globalDlbLagEnabled else 'hash'
      print( "Global LAG load balance distribution:", lb )
