#!/usr/bin/env python3
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.LagCli as LagCli # pylint: disable=consider-using-from-import
import CliPlugin.LagCliLib as LagCliLib # pylint: disable=consider-using-from-import
# pylint: disable-next=consider-using-from-import
import CliPlugin.LagCommonCliLib as LagCommonCliLib
from CliToken.Clear import clearKwNode
import Intf.Log

# clear lacp [channel-group] counters
def clearLacpCounters( mode, args ):
   channelGroupId = None
   if 'LACP' in args:
      channelGroupId = LagCli.ChannelGroup( args.get( 'LACP' ) )
   LagCliLib.syncCounterCheckpoint( LagCliLib.lacpCountersCheckpoint, 
                                    LagCliLib.lacpCounters)
   if channelGroupId:
      Intf.Log.logClearCounters( "lacp", "channel-group " + str( channelGroupId ) )
      portNames = \
         LagCliLib.channelPorts( mode, LagCliLib.portchannelList( mode, 
                                                            channelGroupId )[ 0 ] )
   else:
      Intf.Log.logClearCounters( "lacp", "all ports" )
      portNames = list( LagCliLib.lacpCountersCheckpoint.portCounters )

   for port in portNames:
      counters = LagCliLib.lacpCounters.portCounters.get( port )
      countersCheckpoint = LagCliLib.lacpCountersCheckpoint.portCounters.get( port )

      if counters is None or countersCheckpoint is None:
         continue
      countersCheckpoint.doCopy( counters )

#--------------------------------------------------------------------------------
# clear lacp [ LACP ] counters
#--------------------------------------------------------------------------------
class ClearLacpCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear lacp [ LACP ] counters'
   data = {
      'clear': clearKwNode,
      'lacp': CliCommand.Node( 
         matcher=CliMatcher.KeywordMatcher( 
            'lacp', helpdesc='Link Aggregation Control Protocol (LACP) status' ), 
         guard=LagCommonCliLib.lagSupportedGuard ),
      'LACP': CliMatcher.IntegerMatcher( 1, 2000, helpdesc='Channel Group ID' ),
      'counters': 'Clear LACP counters',
   }
   handler = clearLacpCounters

BasicCliModes.EnableMode.addCommandClass( ClearLacpCountersCmd )
